#!/usr/bin/env bash

### Master generator (run this from the ./generators folder to generate)
MAXN=100000
MAXV=1000000

## Solver
g++ -O2 ../submissions/accepted/torstein.cpp -o /tmp/a.out
SOLVER=/tmp/a.out

## Destination for generated files
# CAREFUL! EVERYTHING IN THIS DIRECTORY WILL BE ERASED
DESTBASE="../data/secret/gen"
rm -r -f $DESTBASE
mkdir $DESTBASE
DEST="${DESTBASE}"
echo $DEST

# Calling the generation script
COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./generate.py -s $COUNT -n $1 -k $2 -o $3 > $DEST/${padCount}_n$1_k$2_$3.in
}

# Call generator with these flags
for n in 19 $MAXN
do
    generate $n 0 random
    generate $n 5 random
    generate $n 0 maxvals-noise1
    generate $n $MAXV maxvals-noise2
    generate $n 0 distinct-inc
    generate $n 0 distinct-inc-rev
    generate $n 0 distinct-inc-twotimes
    generate $n 0 distinct-inc-twotimes-rev
    generate $n 0 distinct-inc-difftwo
    generate $n 0 distinct-inc-difftwo-rev
    generate $n 0 distinct-inc-difftwo-twotimes
    generate $n 0 distinct-inc-difftwo-twotimes-rev
    generate $n $MAXV maxvals-alternate
    generate $n $MAXV alternate
done

# Generate solutions
if [[ ! -z $SOLVER ]]
then
    for f in $DEST/*.in
    do
        echo "solving $f"
        $SOLVER < $f > ${f%???}.ans
    done
fi
