#!/usr/bin/env bash

MAXT=1000000
MAXN=150000
MAXA=1000000
SEED=1337

DESTINATION="../data/secret/generated"
rm -rf $DESTINATION
mkdir -p $DESTINATION

for n in 19 $MAXN
do
    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+0)) -g "random" > $DESTINATION/secret-random-$n-1.in
    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+1)) -g "random" > $DESTINATION/secret-random-$n-2.in
    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+2)) -g "random" > $DESTINATION/secret-random-$n-3.in
    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+3)) -g "random" > $DESTINATION/secret-random-$n-4.in
    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+4)) -g "random" > $DESTINATION/secret-random-$n-5.in

    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+5)) -g "short" > $DESTINATION/secret-short-$n-1.in
    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+6)) -g "short" > $DESTINATION/secret-short-$n-2.in
    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+7)) -g "short" > $DESTINATION/secret-short-$n-3.in

    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+8)) -g "all" > $DESTINATION/secret-all-$n-1.in
    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+9)) -g "all" > $DESTINATION/secret-all-$n-2.in
    ./generate.py -n $n -t $MAXT -a $MAXA -s $((SEED+0)) -g "all" > $DESTINATION/secret-all-$n-3.in
done

for f in $DESTINATION/*.in
do
    echo "solving $f"
    ../submissions/accepted/petter.py < $f > ${f%???}.ans
done
