#!/usr/bin/env python3
import sys, argparse, random, math

def main():
    parser = argparse.ArgumentParser(description="Generator for the soda problem.")
    parser.add_argument('-x', metavar='X', type=int, required=True, help='max soda with value x')
    parser.add_argument('-y', metavar='Y', type=int, required=True, help='max soda with value y')
    parser.add_argument('-s', metavar='S', type=int, required=True, help='seed')
    parser.add_argument('-n', metavar='N', type=int, required=True, help='iteration, used for different seed')
    args = parser.parse_args()

    random.seed(args.s+args.n)
    maxX = args.x//math.pow(args.n,1.4) # Want some different values.
    maxY = args.y//math.pow(args.n,1.4)


    x = random.randint(0, maxX)
    y = random.randint(0, maxY)
    print(x, y)


if __name__ == "__main__":
    main()
