#!/usr/bin/env python3
n, k = map(int, input().split())
shopping_list = input().split()
category_order = input().split()

# solution using zip and tuples
categories= {}

for i in range(k):
    category = input().split()
    for i in range(int(category[1])):
        categories[category[2 + i]] = category[0]

# shopping list transformed to be the category of each item
# [a, b, c, e, e, d, a, c, b] where X: a, b , Y: c, Z: d, e ->
# [X, X, Y, Z, Z, Z, X, Y, X]
shopping_list_categories = [categories[e] for e in shopping_list]

# map the list of categories to be the index of each category in the
# category order list:
# [X, X, Y, Z, Z, Z, X, Y ,X] category order: [X, Z, Y] ->
# [0, 0, 2, 1, 1, 1, 0, 2, 1]
for i in range(len(shopping_list_categories)):
    for index, category in enumerate(category_order):
        if shopping_list_categories[i] == category:
            shopping_list_categories[i] = index

# Sort the shopping list based on the values in the category shopping list
# which are now the indexes of the categories in the category order list
sorted_shopping_list = [e for _, e in sorted(zip(shopping_list_categories, shopping_list))]

# print the result
print(" ".join(sorted_shopping_list))
