#include <iostream>
#include <unordered_map>
#include <string>
#include <vector>
#include <algorithm>
#include <functional>

using namespace std;
#define rep(i,n) for(int i=0;i<(n);i++)

int main() {
    std::ios::sync_with_stdio(false); // Speedup (do not mix with scanf/prinf)
    std::cin.tie(NULL); // Speedup (do not mix with scanf/prinf)

    int n, k;
    cin >> n >> k;
    
    vector<string> items(n);
    rep(i, n) cin >> items[i];

    vector<string> order(k);
    rep(i, k) cin >> order[i];
    
    unordered_map<string, int> position;
    rep(i, k) position[order[i]] = i;

    unordered_map<string, string> category_of_item;
    rep(i, k) {
        string cat;
        int m;
        cin >> cat >> m;
        rep(j, m) {
            string item;
            cin >> item;
            category_of_item[item] = cat;
        }
    }

    sort(std::begin(items), std::end(items), [&](string a, string b) {return position[category_of_item[b]] > position[category_of_item[a]]; });

    rep(i, n) cout << items[i] << " ";
    cout << endl;

    return 0;
}
