#!/usr/bin/env python3

# Reason for wrong answer: Does not prioritize the vertexes
# when using djikstra. Therefore the shortest path is not always found
def dijkstra(graph, source):
    dist = [None for _ in range(len(graph))]
    q = []
    q.append((source, 0))

    while q:
        # time and vertex to reach it
        u, t = q.pop(0)
        if dist[u] != None:
            continue
        dist[u] = t
        # add all neighbors of vertex u to queue
        for v, w in graph[u]:
            # add weight to distance to u
            q.append((v, t + w))
    return dist

# input handling
n, m, w, f = map(int, input().split())
water_depots = list(map(int, input().split()))
food_depots = list(map(int, input().split()))

graph = [[] for _ in range(n)]
for _ in range(m):
    a, b, t = map(int, input().split())
    graph[a].append((b, t))
    graph[b].append((a, t))


dist_from_source = dijkstra(graph, 0)

graph.append([])
for i in range(w):
    graph[n].append((water_depots[i], dist_from_source[water_depots[i]]))

graph.append([])
for i in range(f):
    graph[food_depots[i]].append((n+1, dist_from_source[food_depots[i]]))

dist_with_target = dijkstra(graph, n)

print(dist_with_target[n+1])
