#!/usr/bin/env python3
import sys
from heapq import heappush, heappop, heapify

def dijkstra(graph, src):
    dist = [sys.maxsize] * len(graph)

    dist[src] = 0
    pq = []
    heapify(pq)
    heappush(pq, (0, src))

    while len(pq) != 0:
        (weight_curr, curr) = heappop(pq)
            
        for v in range(0,len(graph[curr])):
            (to, weight) = graph[curr][v]
            if (dist[curr] + weight < dist[to]):
                dist[to] = dist[curr] + weight
                heappush(pq,(dist[to], to))
    return dist

line = input().split(" ")
numNodes = int(line[0])
numLines = int(line[1])
numWaterDepots = int(line[2])
numFoodDepots = int(line[3])

graph =[]

waterDepots = []
line = input().split(" ")
for i in range(0,numWaterDepots):
    waterDepots.append(int(line[i]))

foodDepots = []
line = input().split(" ")
for i in range(0,numFoodDepots):
    foodDepots.append(int(line[i]))

for i in range(0,numNodes+2):
    graph.append([])

for i in range(0,numLines):
    line = input().split(" ")
    a = int(line[0])
    b = int(line[1])
    w = int(line[2])
    graph[a].append((b,w))
    graph[b].append((a,w))

dist_to_water_and_food = dijkstra(graph, 0)

for i in range(0,numWaterDepots):
    graph[numNodes].append((waterDepots[i], dist_to_water_and_food[waterDepots[i]]))

for i in range(0,numFoodDepots):
    graph[foodDepots[i]].append((numNodes+1, dist_to_water_and_food[foodDepots[i]]))

dist = dijkstra(graph, numNodes)
    
print(dist[numNodes+1])
    