#!/usr/bin/env python3
from heapq import heappush, heappop, heapify

def djikstra(graph, source):
    dist = [None for _ in range(len(graph))]
    q = []
    heapify(q)
    heappush(q, (0, source))

    while len(q) != 0:
        # time and vertex to reach it
        t, u = heappop(q)
        if dist[u] != None:
            continue
        dist[u] = t
        # add all neighbors of vertex u to queue
        for v, w in graph[u]:
            # add weight to distance to u
            heappush(q, (t + w, v))

    return dist

# input handling
n, m, w, f = map(int, input().split())
water_depots = list(map(int, input().split()))
food_depots = list(map(int, input().split()))

# Creating a symmetric adjacency list with
# tuples consisting of neighbor and weight of edge
graph = [[] for _ in range(n)]
for _ in range(m):
    a, b, t = map(int, input().split())
    graph[a].append((b, t))
    graph[b].append((a, t))

dist_from_source = djikstra(graph, 0)

# Add a vertex "n" which will represent the source vertex
# Add all the water depots as neighbors such that you
# can only go to a water depot from the "source" vertex
graph.append([])
for i in range(w):
    graph[n].append((water_depots[i], dist_from_source[water_depots[i]]))

# Add a n+1 vertex that will represent the target vertex
# Add this as a neighbor to all food depots, making it
# only accessible from the food depot vertices.
graph.append([])
for i in range(f):
    graph[food_depots[i]].append((n+1, dist_from_source[food_depots[i]]))

dist_with_target = djikstra(graph, n)

print(dist_with_target[n+1])
