#!/usr/bin/env bash

### Master generator (run this from the ./generators folder to generate)
MAXN=50000
MAXM=150000
MAXW=100000
MAXT=99

## Solver
SOLVER=../submissions/accepted/simen.py

## Destination for generated files
# CAREFUL! EVERYTHING IN THIS DIRECTORY WILL BE ERASED
DESTBASE="../data/secret/gen"
rm -r -f $DESTBASE
mkdir $DESTBASE
DEST="${DESTBASE}"
echo $DEST

# Calling the generation script
COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    echo n=$1 m=$2 a=$3 f=$4 shuffle=$5 options=$6
    ./generate.py -s $COUNT -n $1 -p True -c True -m $2 -a $3 -f $4 -u $5 -o $6 -t $MAXT > $DEST/${padCount}.in
    echo n=$1 m=$2 a=$3 f=$4 shuffle=$5 options=$6 > $DEST/${padCount}.desc

}
# Call generator with these flags
for n in 5 $MAXN
do
    generate $n $n 1 1 false path
    generate $n $n 3 3 false path
    generate $n $n $MAXW $MAXW true path
    generate $n $((2*n)) $MAXW $MAXW true path-random
    generate $n $((2*n)) $((MAXW / 10)) $((MAXW / 10)) true path-random
    generate $n $((2*n)) 4 4 false path-path
    generate $n $((2*n)) 4 5 false path-star
    generate $n $((n+1)) 5 5 true hamcycle
    generate $n $((n+5)) 5 5 true hamcycle-random
    generate $n $n 1 1 false path
    generate $n $((2*n)) $((MAXW/3)) $((MAXW/3)) false sausage
    generate $n $((2*n)) 4 3 true sausage
    generate $n $((3*n)) $((MAXW/3)) $((MAXW/3)) false sausage2
    generate $n $((3*n)) 3 4 false sausage3
    generate $n $((3*n)) $((MAXW/10)) $((MAXW/10)) true sausage3
    generate $n $n 10 10 false binarytree
    generate $n $((2*n)) $((MAXW/2)) $((MAXW/2)) true binarytree-binarytree
    # generate $n $n $MAXW $MAXW true binarytree-extraZeroEdges3
    # generate $n $n $MAXW $MAXW true path-extraZeroEdges2
    # generate $n $n $MAXW $MAXW true path-extraZeroEdges3
    generate $n $n 4 4 false star
    generate $n $n 4 4 true star
    generate $n $((n+1)) 1 $((MAXW/5)) false hamcycle
    generate $n $((n+1)) 1 1 true hamcycle
    generate $n $((5*n/4+1)) 2 2 true hamcycle-random
    generate $n $MAXM 2 3 true path-random #20
    # generate $n $((MAXM-4)) $MAXW $MAXW true binarytree-random-extraZeroEdges4
    generate $n $MAXM $((MAXW/5)) $((MAXW/5)) true star-random
    generate $n $MAXM $((MAXW/5)) $((MAXW/5)) false sqrstar
    generate $n $MAXM 5 5 true sqrstar
    generate $n $MAXM 30 50 true sqrstar-random
    # generate $n $((5*n/3)) $MAXW $MAXW true path-random-extraZeroEdges1
    # generate $n $((5*n/3)) $MAXW $MAXW true star-random-extraZeroEdges2
    generate $n $((n + 10)) 50 50 true sqrstar-random
    # generate $n $n $MAXW $MAXW true sqrstar-random-extraZeroEdges10
done

# Generate solutions
if [[ ! -z $SOLVER ]]
then
    for f in $DEST/*.in
    do
        echo "solving $f"
        $SOLVER < $f > ${f%???}.ans
    done
fi
