#!/usr/bin/env python3
from collections import defaultdict

n, m, k = map(int, input().split())
bomb_goal = list(map(int, input().split()))
graph = [[i] for i in range(n+1)]

for _ in range(m):
    u, v = map(int, input().split())
    graph[u].append(v)
    graph[v].append(u)

graph_with_bombs = [n[:] for n in graph]
for goal in bomb_goal:
    graph_with_bombs[0].append(goal)
    graph_with_bombs[goal].append(0)


def can_use_x_days(days):
    edge_weights = init_edge_weights(graph, bomb_goal, days)
    count = 0
    while dfs_with_update(edge_weights, 0, 0, 0, days + 1, set()):
        count += 1
    return count == k

def dfs_with_update(edge_weights, start_room, start_day, target_room, target_day, visited):
    if start_day == target_day and start_room == target_room:
        return True
    visited.add((start_room, start_day))
    for next_room, next_day in adj_func(start_room, start_day, edge_weights):
        if (next_room, next_day) in visited:
            continue
        if dfs_with_update(edge_weights, next_room, next_day, target_room, target_day, visited):
            edge_weights[(start_room, start_day, next_room, next_day)] -= 1
            edge_weights[(next_room, next_day, start_room, start_day)] += 1
            return True
    return False


def init_edge_weights(graph, bomb_goal, days):
    edge_weights = defaultdict(lambda: 0)

    for day in range(days):
        for node in range(len(graph)):
            edge_weights[(node, day, node, day + 1)] = k
            for neighbour in graph[node]:
                edge_weights[(node, day, neighbour, day + 1)] += 1
    
    for room in bomb_goal:
        edge_weights[(room, days, 0, days + 1)] += 1
    
    return edge_weights

def adj_func(room, day, edge_weights):
    output = []
    for neighbour in graph_with_bombs[room]:
        if edge_weights[(room, day, neighbour, day + 1)] > 0:
            output.append((neighbour, day + 1))
        if edge_weights[(room, day, neighbour, day - 1)] > 0:
            output.append((neighbour, day - 1))
    return output

lb = 0
ub = n + k + 2

while lb + 1 < ub:
    guess = (lb + ub) // 2
    if can_use_x_days(guess):
        ub = guess
    else:
        lb = guess

print(ub)

