#!/usr/bin/env python3
from math import sqrt

n, d = map(int, input().split())

islands = []
uf = [i for i in range(n)]

def find(island):
    root = island
    while root != uf[root]:
        uf[root] = uf[uf[root]]
        root = uf[root]
    return root

def union(fro, to):
    rootfro = find(fro)
    rootto = find(to)
    if rootfro == rootto:
        return
    else:
        uf[rootfro] = rootto

for i in range(n):
    x, y = map(int, input().split())
    for j in range(len(islands)):
        xi, yi = islands[j]
        distance = sqrt(float(abs(xi - x)**2 + abs(yi - y)**2))
        if d >= distance:
            # Union find if edge
            union(i, j)
            break
        
    islands.append((x, y))

components = { }
for i in range(n):
    # does not use find to discover dependency groups.
    # [2, 2, 2, 2, 3, 3] are considered two groups in this solution
    if str(uf[i]) in components:
        components[str(uf[i])].append(str(i+1))
    else:
        components[str(uf[i])] = [str(i+1)]

largest_component = max(components, key=lambda x:len(components[x]))
print(' '.join(components[largest_component]))
