#!/usr/bin/env python3
from math import sqrt

n, d = map(int, input().split())

islands = []
uf = [i for i in range(n)]
size = [1 for _ in range(n)]

def find(island):
    root = island
    while root != uf[root]:
        uf[root] = uf[uf[root]]
        root = uf[root]
    return root

def union(fro, to):
    rootfro = find(fro)
    rootto = find(to)
    if rootfro == rootto:
        return
    
    if size[rootfro] < size[rootto]:
        uf[rootfro] = rootto
        size[rootto] += size[rootfro]

    else:
        uf[rootto] = rootfro
        size[rootfro] += size[rootto]

for i in range(n):
    x, y = map(int, input().split())
    for j in range(len(islands)):
        xi, yi = islands[j]
        distance = sqrt(float(abs(xi - x)**2 + abs(yi - y)**2))
        if d >= distance:
            # Union find if edge
            union(i, j)
        
    islands.append((x, y))

components = { }
for i in range(n):
    # use find again to avoid relation issues uf[6] = 3 -> uf[3] = 2
    if str(uf[find(i)]) in components:
        components[str(uf[i])].append(str(i+1))
    else:
        components[str(uf[i])] = [str(i+1)]

components = sorted(components.items(), key=lambda x: len(x[1]), reverse=True)

answer = ""
for k, v in components:
    answer += " ".join(v) + " "
print(answer.strip())