#include <iostream>
#include <vector>
#include <algorithm>
#include <functional>

using namespace std;

// Various
#define rep(i,n) for(int i=0;i<(n);i++)
#define pow2(a) ((a)*(a))
#define sq_dst(i,j,x,y) (pow2((long long) ((x[(i)]) - (x[(j)]))) + pow2((long long) ((y[(i)]) - (y[(j)]))))
#define sff(a,b)    scanf("%d %d", &a, &b)

int dfs(int u, vector<int>* graph, bool* visited) {
    if (visited[u]) return 0;
    visited[u] = true;

    int count = 1;
    rep(i, graph[u].size()) {
        int v = graph[u][i];
        count += dfs(v, graph, visited);
    }
    return count;
}

int main() {
    // Read input
    int n, d;
    sff(n, d);
    long long d_sq = ((long long) d) * ((long long) d);

    int* x = new int[n];
    int* y = new int[n];
    rep(i, n) sff(x[i], y[i]);

    // Construct graph (adj. list)
    vector<int>* graph = new vector<int>[n]();

    rep(i, n) {
        for (int j=i+1; j<n; j++) {
            if (sq_dst(i, j, x, y) <= d_sq) {
                graph[i].push_back(j);
                graph[j].push_back(i);
            }
        }
    }

    int* utility = new int[n];
    rep(i, n) {
        // The slow part - run dfs n times
        bool* visited = new bool[n]();
        utility[i] = dfs(i, graph, visited);
    }

    vector<int> order(n);
    rep(i, n) order[i] = i;
    
    // sort i by utility[i]
    sort(order.begin(), order.end(), [utility](int a, int b) { return utility[a] > utility[b]; });
    rep(i, n) printf("%d ", order[i]+1);
    printf("\n");

    return 0;
}
