#!/usr/bin/env python3
from math import sqrt

n, d = map(int, input().split())

islands = []
island_relations = [[i] for i in range(n)]

for i in range(n):
    x, y = map(int, input().split())
    for j in range(len(islands)):
        xi, yi = islands[j]
        distance = sqrt(float(abs(xi - x)**2 + abs(yi - y)**2))
        if d >= distance:
            # Union find if edge
            island_relations[i].append(j)
    islands.append((x, y))

dic = {}
for island in island_relations:
    for key in island:
        isle = key + 1
        if isle in dic:
            dic[isle].update([i + 1 for i in island])
        else:
            dic[isle] = set()
            dic[isle].update([i + 1 for i in island])

for k1 in dic:
    for k2 in dic[k1]:
        dic[k2].update(dic[k1])

s = sorted(dic.items(), key=lambda x: len(x[1]), reverse=True)
answer = []
for k, v in s:
    for x in v:
        if x not in answer:
            answer.append(x)
print(" ".join([str(x) for x in answer]))
