//
// Created by Brigt Håvardstun on 03/10/2021.
//
#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

struct Point{
    long double x;
    long double y;
};

struct Interval{
    Point point;
    long double seconds;
};

long double distanceTo(Point point1, Point point2){
    return sqrt((point1.x-point2.x)*(point1.x-point2.x)+(point1.y-point2.y)*(point1.y-point2.y));
}

long double solve(Interval* intervals,  int n){

    long double lowestTime = -1;
    long int i,j;
    for(i=0; i<n; i++){
        long double distance = 0;
        long double time = 0;
        Point prev = intervals[i].point;
        bool found = false;
        for(j=i+1; j<n; j++){
            long double currDistance =  distanceTo(prev, intervals[j].point);

            if(distance + currDistance >= 100){
                long double distance_needed = 100-distance;
                long double percentile = distance_needed/currDistance;
                long double time_spent_last_part = intervals[j].seconds*percentile;

                
                time += time_spent_last_part;
                found = true;


                break;

            }
            distance += currDistance;
            time += intervals[j].seconds;
            prev = intervals[j].point;

        }
        if(found && (lowestTime > time || lowestTime == -1) ){

            lowestTime = time;
        }
    }
    return  lowestTime;

}
int main(){
    long int n;
    scanf("%ld", &n);
    n += 1; // Adding (0,0,0) in start.
    long max_val = n;// Just a random amount of space?
    Interval intervals[max_val];

    // Adding start location to make rest easier.
    Point pointZero;
    pointZero.x= 0;
    pointZero.y= 0;
    Interval intervalZero;
    intervalZero.point = pointZero;
    intervalZero.seconds = 0;

    intervals[0] = intervalZero;


    long int i;
    long double prevSeconds = 0;
    for(i=1; i<n; i++){
        long double x, y, t;
        scanf("%Lf %Lf %Lf", &x, &y, &t);
        Point point;
        point.x = x;
        point.y = y;
        Interval interval;
        interval.point = point;
        interval.seconds = t-prevSeconds;
        intervals[i] = interval;
        prevSeconds = t;
        //cout << "itr: " << i << endl;
    }

    long double frontToBack = solve(intervals, n);
    Interval revIntervals[max_val]; // Reverse the intervals.
    long double prevTime = 0;
    int j;
    for(i=n-1,j=0; i>=0; i--, j++){
        Interval interval;
        interval.seconds = prevTime;
        interval.point = intervals[i].point;
        prevTime = intervals[i].seconds;
        revIntervals[j] = interval;
    }

    long double backToFront =  solve(revIntervals, n);
    if(frontToBack > backToFront){
        cout << backToFront << endl;
    } else {
        cout << frontToBack << endl;
    }   
}