#!/usr/bin/env python3
import math

n = int(input())
points = [[0, 0, 0]]
for _ in range(n):
    x, y, t = map(float, input().split())
    points.append([x, y, t])
n += 1

def dist(x1, y1, x2, y2):
    return math.sqrt(((x2-x1)**2)+((y2-y1)**2))

i, j, cd, ct, best = 0, 0, 0, 0, float("inf")
while i < n  - 1 and j < n:
    xi, yi, ti = points[i]
    xj, yj, tj = points[j]

    if cd < 100 and j < n - 1:
        cd += dist(xj, yj, points[j+1][0], points[j+1][1])
        ct += points[j+1][2] - tj
        j += 1
        continue
    elif cd < 100:
        break
    
    xj_prev, yj_prev, tj_prev = points[j-1]
    xi_next, yi_next, ti_next = points[i+1]

    start_dist = dist(xi, yi, xi_next, yi_next)
    end_dist = dist(xj, yj, xj_prev, yj_prev)

    start_time = points[i+1][2] - ti
    end_time = tj - points[j-1][2]

    start_speed = start_dist / start_time
    end_speed = end_dist / end_time

    if start_dist != 0:
        missing_start_dist = 100 - (cd - start_dist)
        missing_start_time = ct - start_time
        time = missing_start_time + (missing_start_dist / start_speed)
        if missing_start_dist >= 0 and time < best:
            best = time

    if end_dist != 0:
        missing_end_dist = 100 - (cd - end_dist)
        missing_end_time = ct - end_time
        time = missing_end_time + (missing_end_dist / end_speed)
        if missing_end_dist >= 0 and time < best:
            best = time

    cd -= start_dist
    ct -= start_time
    i += 1

print(best)
