#!/usr/bin/env python3
from __future__ import division
from heapq import heappush, heappop
INF = float('inf')
EPS = 1e-8

# Read input
n, m = [int(x) for x in input().split()]
t, s1, s2 = [int(x) for x in input().split()] # Trunk, source1, source2

# Adding supersource (at vertex 0)
s = 0
n += 1

matrix = [[0] * n for _ in range(n)]
adjlis = [[] for _ in range(n)]

for _ in range(m):
    u, v, x = [int(x) for x in input().split()]
    matrix[u][v] = x
    matrix[v][u] = x
    adjlis[u].append(v)
    adjlis[v].append(u)
    
# Strategy: binary search over quantity obtainable. Create graph where
# supersources s have the guessed capacity to s1 s2 respectively.
adjlis[s].append(s1)
adjlis[s].append(s2)
adjlis[s1].append(s)
adjlis[s2].append(s)


def canFindFlow(targetflow):
    mtx = [[matrix[i][j] for j in range(n)] for i in range(n)]
    mtx[s][s1] = targetflow / 2
    mtx[s][s2] = targetflow / 2
      
    def findPath():
        ## Bottleneck Dijkstra to find best path
        bottleneck = [0] * n
        bottleneck[s] = INF
        parent = [-2] * n
        q = [(-INF, s, -1)]
        while len(q) > 0:
            neg_bneck, node, p = heappop(q)
            if (-neg_bneck < bottleneck[node]):
                continue
            
            for nb in adjlis[node]:
                propNeck = min(-neg_bneck, mtx[node][nb])
                if propNeck > bottleneck[nb]:
                    heappush(q, (-propNeck, nb, node))
                    bottleneck[nb] = propNeck
                    parent[nb] = node
        
        if parent[t] < 0:
            return None, 0
        
        ## Retrieve the edges of the s-t path
        edges = []
        node = t
        while parent[node] >= 0:
            edges.append((parent[node], node))
            node = parent[node]
            
        return edges, bottleneck[t]
        
    def augment(edges, delta):
        for a, b in edges:
            mtx[a][b] -= delta
            mtx[b][a] += delta
    
    # The crux of the max flow algorithm
    flow = 0
    while True:
        edges, bottleneck = findPath()
        if bottleneck <= 0:
            break
        augment(edges, bottleneck)
        flow += bottleneck
    
    return abs(flow - targetflow) < EPS
    
    
lb = 0
ub = 1000 * 1000 + 1
while lb + 1 < ub:
    mid = (lb + ub) // 2
    if canFindFlow(mid):
        lb = mid
    else:
        ub = mid
        
print(lb)
