#!/usr/bin/env python3
from heapq import heappop, heappush

EPS = 1e-8

n = int(input())
gdp = [int(x) for x in input().split()]
pop = [int(x) for x in input().split()]

graph = [[] for _ in range(n)]
for _ in range(n - 1):
    a, b = [int(x) - 1 for x in input().split()]
    graph[a].append(b)
    graph[b].append(a)
    
parent = [-1]*n
root = 0

## Find parent in rooted tree.
q = [0]
enqueued = [False] * n
enqueued[0] = True
while len(q) > 0:
    u = q.pop()
    for nb in graph[u]:
        if not enqueued[nb]:
            q.append(nb)
            parent[nb] = u
            enqueued[nb] = True

## Union-by-rank structure
islands = list(range(n))
rank = [1] * n

def find(a):
    global islands
    if islands[a] == a:
        return a
    islands[a] = find(islands[a])
    return islands[a]

def union(child, pap):
    global parent, islands
    a = find(child)
    b = find(pap)
    newparent = parent[b]
    if a != b:
        a, b = a if rank[a] < rank[b] else b, b if rank[a] < rank[b] else a
        if rank[a] == rank[b]:
            rank[b] += 1
        islands[a] = b
        gdp[b] += gdp[a]
        pop[b] += pop[a]
        parent[b] = newparent
    
## Strategy: Find blob of cities with highest gdp/person --- if it is root,
## we are done. Otherwise merge with parent blob.
pq = []
for i in range(n):
    heappush(pq, (-gdp[i]/pop[i], gdp[i], pop[i], i)) # minus to sort correctly
    
while len(pq) > 0:
    _, g, p, u = heappop(pq)
    if u != find(u) or g != gdp[u] or p != pop[u]:
        ## Already processed; ignore
        continue
    
    if find(root) == find(u):
        # Done!
        break
    
    ## Merge this with parent blob
    assert(u != parent[u])
    assert(find(root) != find(u))
    assert(find(u) != find(parent[u]))
    union(u, parent[u])
    u = find(u)
    heappush(pq, (-gdp[u]/pop[u], gdp[u], pop[u], u))

print(gdp[find(root)]/pop[find(root)])
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    