#!/usr/bin/env python2
from __future__ import print_function, division
from sys import stdin

## O(n log n) solution to period ticket
## Author: Torstein Stromme

s, p, m, n = [int(x) for x in stdin.readline().split()]
trips = [int(x) for x in stdin.readline().split()]

dp = [0]

for d in trips:
    ## Search for first entry which is included in monthly ticket covering this
    lo = -1 # def not included
    hi = len(trips) - 1 # def included
    while lo + 1 < hi:
        mid = (lo + hi) // 2
        if trips[mid] <= d - m:
            lo = mid
        else:
            hi = mid
            
    dp.append(min(s + dp[-1], p + dp[hi]))
    
print(dp[-1])