#!/bin/bash

# Set the problem name to generate correct file names
PROBLEMNAME="alehouse"

# Set this if you want to generate answers.
# g++ -O2 submissions/accepted/sol.cpp -o /tmp/a.out
cp ../../submissions/accepted/torstein_nlogn.py /tmp/sol.py
SOLVER=/tmp/sol.py
MAXN=100000
MAXK=604799999

subfolders=(a_small b_random c_nooverlap d_samedur e_peak) # (folderA folderB folderC)
for i in ${subfolders[@]}
do
    rm -r $i
    if [ ! -d $i ]
    then
        mkdir $i
    fi
done

COUNT=0
generate() {
    ((COUNT++))
    printf -v padCount "%02d" $COUNT
    ./gendata.py -s $COUNT -n $1 -k $2 -o $3 > $DR/${padCount}_n$1_k$2_$3.in
}

echo "Generating dataset 1... (manual)"
DR="a_small"

generate 10 1 smallrange
generate 10 2 smallrange
generate 10 4 smallrange
generate 10 5 smallrange
generate 10 1 smallrange_nooverlap
generate 10 2 smallrange_nooverlap
generate 10 3 smallrange_nooverlap
generate 10 6 smallrange_nooverlap
generate 10 10 smallrange_nooverlap
generate 10 20 smallrange_nooverlap
generate 10 30 smallrange_nooverlap
generate 10 40 smallrange_nooverlap
generate 10 1 smallrange_samedur
generate 10 2 smallrange_samedur
generate 10 3 smallrange_samedur
generate 10 4 smallrange_samedur
generate 10 5 smallrange_samedur
generate 10 6 smallrange_samedur

DR="b_random"

generate $MAXN 1 random
generate $(($MAXN - 1)) 1 random
generate $MAXN $(($MAXK / 100)) random
generate $(($MAXN - 1)) $(($MAXK / 100)) random
generate $(($MAXN - 1)) $MAXK random

DR="c_nooverlap"

generate $MAXN 1 nooverlap
generate $MAXN $(($MAXK / 100)) nooverlap
generate $(($MAXN - 1)) $(($MAXK / 100000)) nooverlap

DR="d_samedur"

generate $MAXN 1 samedur
generate $(($MAXN - 1)) 1 samedur
generate $MAXN $(($MAXK / $MAXN)) samedur
generate $(($MAXN - 1)) $((10 * $MAXK / $MAXN)) samedur
generate $(($MAXN - 1)) $(($MAXK / 10)) samedur

DR="e_peak"

generate $MAXN 1 peak
generate $MAXN 1 peak
generate $MAXN 1 peak
generate $MAXN 10000 peak
generate $(($MAXN - 1)) 1 peak
generate $(($MAXN - 1)) 1 peak
generate $(($MAXN - 1)) 1 peak
generate $(($MAXN - 1)) 10000 peak




# generate solutions for all files
if [[ ! -z $SOLVER ]]
then
    for i in ${subfolders[@]}
    do
        for f in $i/*.in
        do
            echo "solving $f"
            $SOLVER < $f > ${f%???}.ans
        done
    done
fi
