#include <bits/stdc++.h>

#define rep(a, b)   for(int a = 0; a < (b); ++a)
#define all(a)      (a).begin(),(a).end()
#define endl        '\n'

using namespace std;
using Graph = vector<vector<int>>;
using ll = long long;

struct AhoCorasick {
    const static int A = 27;
    struct Vert {
        array<int,A> next = {};
        unordered_map<int,int> balance;
    };
    vector<Vert> trie = {{}};

    int addWord(string& s) {
        int v = 0;
        for(auto c : s) {
            c-='a';
            if(!trie[v].next[c]) {
                trie[v].next[c] = trie.size();
                trie.emplace_back();
            }
            v = trie[v].next[c];
        }
        return v;
    }

    void finalize() {
        queue<array<int,4>> q{{{0,0,0,0}}};
        while(size(q)) {
            auto [v, parent, plink, pch] = q.front(); q.pop();
            int link = parent == 0 ? 0 : trie[plink].next[pch];
            rep(c,A) {
                if(!trie[v].next[c]) trie[v].next[c] = trie[link].next[c];
                else q.push({trie[v].next[c], v, link, c});
            }

            if(v==0) continue; // safety reasons :)
            // propagate data over suffix links
            for(auto [id, bal] : trie[link].balance)
                trie[v].balance[id] += bal;
        }
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.precision(10);
    string lineskip;

    // read input
    int n,m,k; cin>>n>>m>>k;
    vector<string> names(n);
    vector<pair<int,int>> edges(m);
    vector<string> texts(k);
    getline(cin,lineskip); // skip newline
    for(auto& name : names) getline(cin,name);
    for(auto& [u,v] : edges) cin>>u>>v, --u,--v;
    getline(cin,lineskip); // skip newline
    for(auto& text : texts) getline(cin,text);
    // replace spaces
    for(auto& name : names) replace(all(name), ' ', char('z'+1));
    for(auto& text : texts) replace(all(text), ' ', char('z'+1));

    // build aho corasick
    AhoCorasick aho;
    vector node(n,0);
    rep(i,size(names))
        node[i] = aho.addWord(names[i]);
    rep(i,size(edges)) {
        auto [u,v] = edges[i];
        aho.trie[node[u]].balance[i] -= 1;
        aho.trie[node[v]].balance[i] += 1;
    }
    aho.finalize();



    for(auto& text : texts) {
        map<int,int> balance;
        int v = 0;
        for(auto c : text) {
            v = aho.trie[v].next[c-'a'];
            for(auto [id, bal] : aho.trie[v].balance)
                balance[id] += bal;
        }

        bool good = true;
        for(auto [edge_id, bal] : balance) {
//            auto [u,v] = edges[edge_id];
//            cout << text << ' '  << names[u] << ' ' << names[v] << ' ' << bal << endl;
            good &= (bal==0);
            if (!good) break;
        }
        cout << (good ? "yes" : "no") << endl;
    }

    return 0;
}
