import java.util.*;

class D {
	
	public static double[] boxes;
	public static boolean[] opened;
	public static double hasWon = -1;
	
	public static double calculateBankOffer()
	{
		double offer = 0.0; int unopened = 0;
		for(int i = 0; i < boxes.length; i++)
		{
			if(!opened[i]) 
			{ 
				offer += boxes[i];
				unopened++;
			}
		}
		return (offer / (double)unopened) * 0.9;
	}
	
	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		int numBoxes = sc.nextInt();
		boxes = new double[numBoxes];
		opened = new boolean[numBoxes]; // standard all values are false
		for(int i = 0; i < numBoxes; i++) 
		{
			double money = sc.nextDouble();
			boxes[i] = money;  
		}
		
		int chosenBox = sc.nextInt() - 1;
		opened[chosenBox] = true;
		
		int actions = sc.nextInt();
		for(int i = 0; i < actions; i++)
		{
			String line = sc.nextLine();
			String[] parts = line.split(" ");
			if(parts[0].equals("O")) // contestant opened box
			{
				int box = Integer.parseInt(parts[1]) - 1;
				opened[box] = true;
			}
			else if(parts[0].equals("B")) // bank makes an offer
			{
				if(parts[1].equals("D") && hasWon == -1)
				{
					hasWon = calculateBankOffer();
				}
			}
		}
		
		if(hasWon == -1) // contestant has not accepted any offer from the bank
		{
			System.out.printf("%.2f\n", boxes[chosenBox]);
			System.out.printf("%.2f\n", boxes[chosenBox]);
		}
		else // contestant has accepted an offer from the bank
		{
			System.out.printf("%.2f\n", boxes[chosenBox]);
			System.out.printf("%.2f\n", hasWon);
		}
	}
}