package problems.administration;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;


public class ChrSolution {

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		Deque<String> returned = new ArrayDeque<String>();
		Map<String, Lend> onLend = new HashMap<String, Lend>();
		Map<String, Integer> cost = new HashMap<String, Integer>();
		Set<Lend> lent = new HashSet<Lend>();
		int n = sc.nextInt();
		boolean corrupt = false;
		while(!corrupt && n --> 0){
			int time = sc.nextInt();
			sc.next();
			String name = sc.next();
			String op = sc.next();
			String book = sc.next();
			if("books".equals(op) && "become".equals(book)){
				sc.next();
				int b = Integer.parseInt(name);
				if(b > returned.size()) corrupt = true;
				else
					while(!returned.isEmpty() && b --> 0){
						book = returned.pop();
						onLend.remove(book);
					}
			} else if("borrows".equals(op)){
				if(onLend.containsKey(book)){
					corrupt = true;
				} else{
					onLend.put(book, new Lend(name, book, time));
				}
				cost.put(name, 0);
				
			} else if("returns".equals(op)){
				Lend l = onLend.get(book);
				if(l != null && l.name.equals(name)){
					returned.push(book);
					lent.add(new Lend(name, book, time - l.time));
				} else{
					corrupt = true;
				}
				cost.put(name, 0);
			}
		}
		if(corrupt){
			System.out.println("CORRUPT");
		} else{
			for(String s : returned){
				onLend.remove(s);
			}
			for(Lend l : lent){
				if(l.time > 3){
					cost.put(l.name, cost.get(l.name) + (l.time - 3) * 23);
				}
			}
			for(Lend l : onLend.values()){
				cost.put(l.name, cost.get(l.name) + 1000);
			}
			ArrayList<String> names = new ArrayList<String>(cost.keySet());
			Collections.sort(names);
			for(String s : names){
				System.out.println(s+" E"+cost(cost.get(s)));
			}
		}
	}
	
	public static String cost(int n){
		StringBuilder sb = new StringBuilder(String.valueOf(n));
		if(n == 0) return "0.00";
		if(n < 100) return "0."+n;
		if(sb.length() >= 3){
			sb.insert(sb.length() - 2, '.');
		}
		return sb.toString();
	}
	
	static class Lend{
		public String name, book;
		public int time;
		public Lend(String name, String book, int time){
			this.name = name;
			this.time = time;
			this.book = book;
		}
		
		public boolean equals(Object that){
			if(that instanceof Lend){
				Lend l = (Lend) that;
				return name.equals(l.name) && book.equals(l.book);
			}
			return false;
		}
		
		public String toString(){
			return name+" :: "+book+" :: "+time;
		}
	}
}
