#include "validation.h"
#include<cmath>
#include<queue>

// Interactor for Journey to Mastery.
// Can use one of three strategies:
// - "fixed": use a fixed list of actions.
// - "optimal": make the dummy take optimal actions.
// - "random": make the dummy take random actions.
// The interactor will account for cooldowns by sending/verifying '-'.

using namespace std;

int movesUsed = 0;
int playerDistance;
int playerCooldown = 0;
bool dummyCooldown = 0;
bool deadUnlessShoryuken = 0;
bool playerWins = 0;
bool dummyWins = 0;
char playerCommand;
int hadoukensSpammed = 0;

queue <int> playerHadoukens;
queue <int> dummyHadoukens;

void updateHadoukens(bool playerTurn)

{
    //if only opponent has Hadouken on screen
    if(!dummyHadoukens.empty())
    {
        if(dummyHadoukens.front() == movesUsed - 1)
        {
            if(playerTurn) dummyWins = 1;
            else deadUnlessShoryuken = 1;
            dummyHadoukens.pop();
        }
    }
    //if only player has Hadouken on screen
    if(!playerHadoukens.empty())
    {
        if(movesUsed - playerHadoukens.front() + 1 == playerDistance)
        {
            playerWins = 1;
        }

        if(movesUsed - playerHadoukens.front() + 1 > playerDistance)
        {
            playerHadoukens.pop();
        }
    }
}

void changeGameStateDummy(char action)
{
    if(action == 'W') playerDistance = max(playerDistance - 1, 1);
    
    if(action == 'J') 
    {
        //cerr << "HERE" <<endl;
        playerDistance = max(playerDistance - 2, 1);
        if (playerDistance == 1)
        deadUnlessShoryuken = 1;
    }

    if(action == 'K')
    {
        if(playerDistance <= 2) deadUnlessShoryuken = 1;
        dummyCooldown = 1;
    }

    if(action == 'H')
    {
        if(! playerHadoukens.empty()) playerHadoukens.pop();
        else dummyHadoukens.push(movesUsed + playerDistance);
        dummyCooldown = 1;
    }

}

void changeGameStatePlayer(char action)
{
    if(deadUnlessShoryuken && action != 'S') dummyWins = 1;
    deadUnlessShoryuken = 0;

    if(action == 'S')
    {
        if(playerDistance == 1) playerWins = 1;
        playerCooldown = 2;
    }

    if(action == 'K')
    {
        if(playerDistance <= 2) playerWins = 1;
        playerCooldown = 1;
    }

    if(action == 'H')
    {
        if(! dummyHadoukens.empty()) dummyHadoukens.pop();
        else playerHadoukens.push(movesUsed);
        playerCooldown = 1;
    }

}

char getNextCommand(string& strategy, string& commands, int index,  mt19937_64& rng)
{
    if(strategy == "fixed")
    {
        if(index < commands.size())
        {
            return commands[index];
        }
        return 'J';
    }

    if(strategy == "random")
    {

        string choices = "WKJH";
        char result = choices[Random::bits64(rng) % 4];
        return result;

    }

    if(strategy == "optimal")
    {
        if(playerDistance < 3) return 'K';
        if(hadoukensSpammed < 4) { hadoukensSpammed++; return 'H';}
        hadoukensSpammed = 0;
        if(!playerHadoukens.empty())
        {
            if (playerDistance - (movesUsed - playerHadoukens.front() + 1) <= 3) return 'J';
            if (playerDistance - (movesUsed - playerHadoukens.front() + 1) == 4) return 'W';
        }
        int randomChoice = Random::bits64(rng) % 2;
        if(randomChoice == 1) return 'W';
        return 'J';


    }


}

void handleWrongAnswer(OutputValidator& v)
{
    v.WA("player got hit by something");
}

void handleTimeout(OutputValidator& v)
{
    v.WA("player used more than 1000 moves");
}



int main(int argc, char **argv) {
    // Set up the input and answer streams.
    std::ifstream in(argv[1]);
    std::ifstream ans(argv[2]); // Only for custom checker.
    OutputValidator v(argc, argv);

    in >> playerDistance;

    cout << playerDistance << endl;

    string strategy;
    in >> strategy;

    string commands = "";
    int randomSeed = 0;

    if (strategy == "fixed") in >> commands;

    if (strategy == "random" || strategy == "optimal") in >> randomSeed;

    mt19937_64 rng(randomSeed);

        for (int i = 0;; i++)
        {
            movesUsed ++;
            if(movesUsed > 4000) handleTimeout(v);
            if(dummyCooldown)
            {
                cout << "-" << endl;
                dummyCooldown = 0;
                i--;
            }
            else
            {
                char command = getNextCommand(strategy, commands, i, rng);
                cout << command << endl;
                //cerr <<endl<<"COMMAND          "<<command<<endl;
                changeGameStateDummy(command);
            }           

            updateHadoukens(0);

            if(playerWins) 
            {  
                cout << "V" << endl;
                exit(42);
                return 0;
                break;
            }
            if(dummyWins)
            {
                handleWrongAnswer(v);
            }

            movesUsed ++;
            if(playerCooldown)
            {
                if(deadUnlessShoryuken) handleWrongAnswer(v);
                playerCooldown --;
                playerCommand = v.read_string("playerCommand", 1, 1, "-")[0];
            }
            else
            {
                playerCommand = v.read_string("playerCommand", 1, 1, "NKHS")[0];
                //cerr <<endl<< "PLAYERCOMMAND    "<<playerCommand << "      " << playerDistance << endl;
                v.newline();
                changeGameStatePlayer(playerCommand);
            }

            updateHadoukens(1);

            if(dummyWins)
            {
                handleWrongAnswer(v);
            }

            if(playerWins)
            {
                cout << "V" << endl;
                exit(42);
                return 0;
                break;
            }


           

        }

}
