import kotlin.math.PI
import kotlin.math.asin
import kotlin.math.sqrt

fun main() {
  val input = System.`in`.bufferedReader()
  val numberOfCircles = input.readLine().toInt()
  val circles = input.lineSequence().take(numberOfCircles)
    .map { line -> line.split(" ").map { it.toInt() } }
    .mapIndexed { index, (a, b) -> Circle(index, a, b) }
    .toList().findOverlappingCircles()
  println(circles.map {(circle, overlap) ->
    circle.area - overlap.fold(0.0) {acc, other -> acc + circle.overlap(other) }
  }.sum())

}

fun List<Circle>.findOverlappingCircles() = associate { circle ->
  circle to filter { it.left in circle.range || it.right in circle.range }
}


data class Circle(
  val label: Int,
  val x: Int,
  val radius: Int
) {
  val left = x - radius
  val right = x + radius
  val range = left + 1 until right

  val area = PI * radius * radius

  // This might be the long way around :-(
  fun overlap(other: Circle): Double {
    // calculate the area of the kite created by the centers of the 2 circles and the 2 points the cross eachother
    val a = radius.toDouble()
    val b = other.radius.toDouble()
    val c = when {
      x > other.x -> x - other.x
      else -> other.x - x
    }.toDouble()
    val areaKite =  2 *hernonTriangleArea(a,b,c)
    //calculte the hight of the chord
    val chord = areaKite * 2 / c
    val alpha = Math.toDegrees(2.0*asin( chord/(2*radius)))
    // are of the segment to overlap
    return alpha/360*area - hernonTriangleArea(radius.toDouble(), radius.toDouble(), chord)
  }
}


fun hernonTriangleArea(a: Double, b: Double, c: Double): Double {
  val s = (a + b + c) / 2
  return sqrt(s * (s - a) * (s - b) * (s - c))
}
