import java.io.*;

public class MaartenRiemann {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenRiemann().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        int n = Integer.parseInt(reader.readLine());

        int[] xs = new int[n], rs = new int[n];
        for (int i = 0; i < n; i++) {
            String[] line = reader.readLine().split(" ");
            xs[i] = Integer.parseInt(line[0]);
            rs[i] = Integer.parseInt(line[1]);
        }

        double scale = 1000, sum = 0;
        for (double i = -20; i < 20; i += 1 / scale) {
            double y = 0;
            for (int j = 0; j < n; j++) {
                int x = xs[j], r = rs[j];
                if (x - r < i && i < x + r) {
                    y = Math.max(y, Math.sqrt(r * r - (i - x) * (i - x)));
                }
            }
            sum += y;
        }
        System.out.println(sum / scale * 2);
    }
}
