// @EXPECTED_RESULTS@: TIME_LIMIT_EXCEEDED, WRONG_ANSWER
import kotlin.math.min
// To Slow, wrong answer sometimes
fun main() {
  val input = System.`in`.bufferedReader()
  val (lecturerNumber, hallNumber) = input.readLine().split(" ").map { it.toInt() }
  val lectures =
    input.readLine().split(" ").mapIndexed { index, s -> Lecture(index + 1, s.toLong()) }
  val halls = input.readLine().split(" ").mapIndexed { index, s -> Hall(index + 1, s.toLong()) }
  val freeRooms = hallNumber - lecturerNumber
  if (freeRooms < 0) return println("impossible")

  // Flow network
  val size = lecturerNumber + hallNumber + 2
  val graph = Array(size) { LongArray(size) }
  val costs = Array(size) { LongArray(size) }

  lectures.forEach {
    graph[0][it.rank] = 1
    costs[0][it.rank] = 0
  }
  lectures.forEach { lecture ->
    halls.filter { it.capacity >= lecture.students }.forEach {
      graph[lecture.rank][lecturerNumber + it.rank] = 1
      costs[lecture.rank][lecturerNumber + it.rank] = (lecturerNumber - it.rank).toLong() * lecture.rank
    }
  }
  halls.forEach { hall ->
    graph[lecturerNumber + hall.rank][size - 1] = 1
    costs[lecturerNumber + hall.rank][size - 1] = 0
  }

  val maxFlow = MaxFlow(graph, costs)
  val assignment = halls.map { (maxFlow.flow[it.rank].indexOf(1) - hallNumber) }
  when {
    assignment.any { it < 1 } -> println("impossible")
    else -> println(assignment.joinToString(separator = " "))
  }
}

const val INFINITY = Long.MAX_VALUE / 2 - 1

class MaxFlow(val graph: Array<LongArray>, val costs: Array<LongArray>) {
  val size = graph.size
  val flow = Array(size) { LongArray(size) }
  val dad = IntArray(size)
  val pi = LongArray(size)
  var totalFlow = 0L
  var totalCost = 0L

  init {
    maxFlow()
  }

  private fun maxFlow(source: Int = 0, sink: Int = size - 1) {
    while (search(source, sink)) {
      var amount = INFINITY
      var x = sink
      while (x != source) {
        amount = min(
          amount, when (flow[x][dad[x]]) {
            0L -> graph[dad[x]][x] - flow[dad[x]][x]
            else -> flow[x][dad[x]]
          }
        )
        x = dad[x]
      }
      x = sink
      while (x != source) {
        when (flow[x][dad[x]]) {
          0L -> {
            flow[dad[x]][x] += amount
            totalCost += amount * costs[dad[x]][x]
          }
          else -> {
            flow[x][dad[x]] -= amount
            totalCost -= amount * costs[x][dad[x]]
          }
        }
        x = dad[x]
      }
      totalFlow += amount
    }
  }

  private fun search(source: Int, sink: Int): Boolean {
    val found = mutableSetOf<Int>()
    val distance = mutableMapOf<Int, Long>().withDefault { INFINITY }
    distance[source] = 0
    var current = source
    while (current != size) {
      var best = size
      found.add(current)
      for (k in 0 until size) {
        if (k in found) continue

        if (flow[k][current] != 0L) {
          val value = distance.getValue(current) + pi[current] - pi[k] - costs[k][current]
          if (distance.getValue(k) > value) {
            distance[k] = value
            dad[k] = current
          }
        }
        if (flow[current][k] < graph[current][k]) {
          val value = distance.getValue(current) + pi[current] - pi[k] + costs[current][k]
          if (distance.getValue(k) > value) {
            distance[k] = value
            dad[k] = current
          }
        }
        if (distance.getValue(k) < distance.getValue(best)) {
          best = k
        }
      }
      current = best
    }

    repeat(size) {
      pi[it] = min(pi[it] + distance.getValue(it), INFINITY)
    }
    return sink in found
  }

}

interface Vertex {
  val rank: Int
}

data class Lecture(override val rank: Int, val students: Long) : Vertex
data class Hall(override val rank: Int, val capacity: Long) : Vertex

