import java.io.*;
import java.util.*;
import java.util.stream.*;

public class MaartenCubic {
    public static void main(String[] args) throws IOException {
        try (Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)))) {
            new MaartenCubic().run(sc);
        }
    }

    public void run(Scanner sc) throws IOException {
        int n = sc.nextInt(), m = sc.nextInt();
        if (n > m) {
            System.out.println("impossible");
            return;
        }

        List<Integer> xs = new ArrayList<>(n);
        for (int i = 0; i < n; i++) {
            xs.add(sc.nextInt());
        }
        List<Integer> lectures = new ArrayList<>(xs);
        lectures.sort((a, b) -> b - a);

        List<Hall> cs = new ArrayList<>(m);
        for (int i = 0; i < m; i++) {
            cs.add(new Hall(i, sc.nextInt()));
        }
        List<Hall> halls = new ArrayList<>(cs);
        halls.sort(Comparator.<Hall>comparingInt(h -> h.capacity).thenComparing(h -> h.index).reversed());

        List<Hall> schedule = new ArrayList<>();

        for (Integer x : xs) {
            n--;
            lectures.remove(x);
            int noFitRight = 0, noFitLeft = n;
            while (noFitRight < n && lectures.get(noFitRight) <= halls.get(noFitRight).capacity) noFitRight++;
            while (noFitLeft > 0 && lectures.get(noFitLeft - 1) <= halls.get(noFitLeft).capacity) noFitLeft--;

            boolean found = false;
            for (Hall hall : cs) {
                if (hall.used || hall.capacity < x) continue;
                int j = halls.indexOf(hall);
                if (j >= n || noFitLeft <= j && j <= noFitRight) {
                    found = true;
                    schedule.add(hall);
                    hall.used = true;
                    halls.remove(hall);
                    break;
                }
            }

            if (!found) {
                System.out.println("impossible");
                return;
            }
        }

        System.out.println(
                schedule.stream().<String>map(h -> Integer.toString(h.index + 1)).collect(Collectors.joining(" ")));
    }

    static class Hall {
        int index, capacity;
        boolean used;

        Hall(int index, int capacity) {
            this.index = index;
            this.capacity = capacity;
        }
    }
}
