#include "bits/stdc++.h"
using namespace std;
#define all(x) begin(x),end(x)
#define print(v) cerr << #v << ": "; for(auto _ : v) cerr << _ << ' '; cerr << '\n';
#define debug(x) cerr << #x<< ": " << x << '\n';
void impossible() {
    cout << "impossible\n";
    exit(0);
}
// range add, range max, walking on segment tree
const int oo = 1e9;
struct segtree {
    struct node {
        int lazy=0,mn=0;
    };
    vector<node> seg;
    int ptwo;
    segtree(int nn) {
        ptwo=1;
        while(ptwo<nn) ptwo*=2;
        seg.resize(ptwo*2);
    }
    void puttag(int i, int v) {
        seg[i].lazy+=v,seg[i].mn+=v;
    }
    void push(int i) {
        int& la = seg[i].lazy;
        puttag(i*2,la);
        puttag(i*2+1,la);
        la=0;
    }
    void pull(int i) {
        assert(seg[i].lazy==0);
        seg[i].mn = min(seg[i*2].mn,seg[i*2+1].mn);
    }
    void set(int i,int l, int r, int ql, int qr,int v) {
        if(qr<l or r<ql) return;
        if(ql<=l and r<=qr) {
            puttag(i,v);
            return;
        }
        int mid = (l+r)/2;
        push(i);
        set(i*2,l,mid,ql,qr,v);
        set(i*2+1,mid+1,r,ql,qr,v);
        pull(i);
    }
    int get(int i,int l, int r, int ql, int qr) {
        if(qr<l or r<ql) return oo;
        if(ql<=l and r<=qr) {
            return seg[i].mn;
        }
        int mid = (l+r)/2;
        push(i);
        return min(get(i*2,l,mid,ql,qr),get(i*2+1,mid+1,r,ql,qr));
    }
    void set(int l, int r, int v) {
        set(1,0,ptwo-1,l,r,v);
    }
    int get(int l, int r) {
        return get(1,0,ptwo-1,l,r);
    }
    int findFirstBad() {
        int at=1;
        while(at<ptwo) {
            push(at);
            bool goRight = seg[at*2].mn>0;
            at = at*2 + goRight;
        }
        return at-ptwo;
    }
};
int main() {
    // impossible();
    int n,m; cin >> n >> m;
    if(m<n) impossible();
    vector<int> x(n), c(m),coords;
    for(auto& i : x) cin >> i,coords.push_back(i);
    for(auto& i : c) cin >> i,coords.push_back(i);
    sort(all(coords));
    coords.resize(unique(all(coords))-coords.begin());
    auto compressed = [&](int a) {
        return lower_bound(all(coords),a)-coords.begin();
    };
    for(auto& i : x) i=compressed(i);
    for(auto& i : c) i=compressed(i);
    // now integers between 0 and n+m-1
    // two segment trees
    // One for finding last unbalanced coordinate
    // one for finding first good lecture hall
    const int C = coords.size();
    segtree balance(C+1), goodhalls(C);
    vector<vector<int>> hallVs(C,{oo});
    for(int i=m-1;i>=0;--i) {
        hallVs[c[i]].push_back(i);
        balance.set(0,c[i],1);
    }
    balance.set(C,balance.ptwo-1,-1);
    for(int i=0;i<C;++i) {
        goodhalls.set(i,i,hallVs[i].back());
    }
    for(auto i : x) balance.set(0,i,-1);
    if(balance.get(0,C-1)<0) impossible();
    vector<int> res;

    for(int i=0;i<n;++i) {
        // remove x[i]
        balance.set(0,x[i],1);
        // find last >=0
        // removing any hall> last zero is trouble
        int cupper = balance.findFirstBad();
        // find first hall in the order of nicesness, which is < cupper, but >= x[i]
        int myhall = goodhalls.get(x[i],cupper-1);
        res.push_back(myhall+1);
        int cc = c[myhall];
        auto& v = hallVs[cc];
        v.pop_back();
        goodhalls.set(cc,cc,v.back()-myhall);
        balance.set(0,cc,-1);
    }

    string sep = "";
    for(auto i : res) {
        cout << sep << i;
        sep = " ";
    }
    cout << '\n';
}