fun main() {
    val sequence = System.`in`.bufferedReader().readLines()
    val problemsToMatch = sequence.drop(1).first().calculateProblemsSolved()
    val timeToMatch = problemsToMatch.calculateTime()
    sequence.asSequence().drop(2).map { it.calculateProblemsSolved() }
        .filter { it.size >= problemsToMatch.size }
        .count { it.size > problemsToMatch.size || it.calculateTime() <= timeToMatch }.let { println(it) }
}

fun String.calculateProblemsSolved() =
    split(" ").filter { it != "X" }

fun List<String>.calculateTime() = sumOf { it.toLong() }
