import networkx as nx
import matplotlib.pyplot as plt
for sample in (1,2,3):
    with open(f"../data/sample/{sample}.in") as fin:
        n=int(fin.readline())
        a = [(0,0)]
        for i in range(n):
            a.append(tuple(map(int,fin.readline().split())))
        print(a)
        pos = {}
        G = nx.empty_graph()
        def dfs(at, x=0.5, y =0.9, d = 1):
            pos[at] = (x,y)
            ch = a[at][0]
            if ch:
                G.add_node(ch)
                G.add_edge(at,ch)
                dfs(ch,x- 0.7**(d+1),y-0.3,d+1)
            ch = a[at][1]
            if ch:
                G.add_node(ch)
                G.add_edge(at,ch)
                dfs(ch,x + 0.7**(d+1),y-0.3,d+1)
        G.add_node(1)
        dfs(1)
        fig = plt.figure()
        # G.set_edgecolor('red')
        # pos
        nx.draw_networkx_nodes(G,pos,node_size=2000,node_color="white",edgecolors="black" )
        nx.draw_networkx_edges(G,pos )
        nx.draw_networkx_labels(G,pos,font_size=30 )
        fig.savefig(f"visualization{sample}.pdf")
