#include <bits/stdc++.h>
using namespace std;
typedef vector<int> vi;
typedef vector<vi> vvi;
struct SCC {
    int cnt=0,n;
    vvi adj;
    vi lo, in,comp;
    vector<bool> vis;
    SCC(int nn) : n(nn),adj(nn),lo(nn),in(nn),comp(nn,-1),vis(nn) {}
    int compid=0;
    void collect(int at) {
        assert(comp[at]==-1);
        comp[at]=compid;
        for(int to : adj[at]) if(comp[to]==-1) {
            collect(to);
        }
    }
    int run() {
        for(int i=0;i<n;++i) if(!vis[i]) 
            dfs(i);
        for(int i=0;i<n;++i) assert(comp[i]!=-1);
        return compid;
    }
    void dfs(int at) {
        vis[at]=true;
        in[at] = lo[at] = cnt++;
        for(int to : adj[at]) {
            if(!vis[to]) dfs(to),lo[at] = min(lo[at],lo[to]);
            else if(comp[to]==-1) lo[at] = min(lo[at],in[to]);
        }
        if(lo[at]==in[at]) 
            collect(at), compid++;
    }
};
int main() {
    int n,m; cin >> n >> m;
    SCC scc(n);
    for(int i=0;i<m;++i) {
        int a,b; cin >> a >> b,--a,--b;
        scc.adj[a].push_back(b);
    }
    int comps = scc.run();
    vi indeg(comps),outdeg(comps);
    if(comps==1) {
        cout << "0\n";
        exit(0);
    }
    for(int at=0;at<n;++at) for(auto to : scc.adj[at]) {
        if(scc.comp[at]!=scc.comp[to]) {
            indeg[scc.comp[to]]++,outdeg[scc.comp[at]]++;
        }
    }
    int sources = 0, sinks=0;
    for(int i=0;i<comps;++i) {
        if(indeg[i]==0) sources++;
        if(outdeg[i]==0) sinks++;
    }
    cout << max(sources,sinks) << '\n';
}