#include <bits/stdc++.h>
using namespace std;

#define ll long long
const int NMAX = 100000;

vector<int>g[NMAX+5];
vector<int>gt[NMAX+5];
bitset<NMAX+5>viz;
stack<int> st;
vector< vector<int> >strong_components;

///Implementation with Kosaraju


void dfs_kosaraju(int node){
    viz[node] =1;

    for(int i =0; i < g[node].size(); i++) {
        if(!viz[g[node][i]])
            dfs_kosaraju(g[node][i]);
    }

    st.push(node);
}

void dfs_kosaraju_component(int node, vector<int> & strong_component){
    viz[node] =1;
    strong_component.push_back(node);

    for(int i =0; i < gt[node].size(); i++) {
        if(!viz[gt[node][i]])
            dfs_kosaraju_component(gt[node][i],  strong_component);
    }
}

void kosaraju(int n){
    for(int i =1;i<=n;i++){
        if(!viz[i])
            dfs_kosaraju(i);
    }

    viz.reset();

    while(!st.empty()){
        int node = st.top();
        st.pop();

        if(!viz[node]){
            vector<int> strong_component;
            dfs_kosaraju_component(node, strong_component);
            strong_components.push_back(strong_component);
        }
    }

}



int main(){
    int n, m, x, y;
    cin>>n>>m;
    for(int i =1; i <=m; i++){
        cin>>x>>y;
        g[x].push_back(y);
        gt[y].push_back(x);
    }
    kosaraju(n);
    if(strong_components.size() == 1){
        cout<<0<<"\n";
        return 0;
    }

    vector<int>node_components(n+1, 0);
    for(int i =0; i < strong_components.size(); i++)
    {
        for(auto x : strong_components[i])
            node_components[x] = i;
    }


    vector<int>out_edges(strong_components.size(), 0);
    vector<int>in_edges(strong_components.size(), 0);
    for(int i =1; i <= n; i++){
        for(auto x : g[i]){
            if(node_components[x] != node_components[i]){
                in_edges[node_components[x]]++;
                out_edges[node_components[i]]++;
            }
        }
    }

    int leaves =0;
    int root = 0;
    for(int i =0; i < out_edges.size(); i++)
    {
        if(out_edges[i] == 0)
            leaves++;
        if(in_edges[i] == 0)
            root++;
    }
    cout<<max(root, leaves)<<"\n";

    return 0;
}


