import java.io.*;
import java.util.*;

public class Maarten {

    private int n, k;
    private final List<Integer> breathPoints = new ArrayList<>();
    private final List<Long> breathTimes = new ArrayList<>();

    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new Maarten().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        String[] firstLine = reader.readLine().split(" ");
        n = Integer.parseInt(firstLine[0]);
        k = Integer.parseInt(firstLine[1]);

        long[] as = new long[n], bs = new long[n];
        for (int i = 0; i < n; i++) {
            String[] line = reader.readLine().split(" ");
            as[i] = Integer.parseInt(line[0]);
            bs[i] = Integer.parseInt(line[1]);
        }

        breathPoints.add(0);
        for (int i = 1; i < n - 1; i++) {
            if (as[i - 1] > as[i] && as[i] < as[i + 1]) breathPoints.add(i + 1);
        }
        breathPoints.add(n);

        for (int i = 0; i < breathPoints.size() - 1; i++) {
            breathTimes.add(
                    Arrays.stream(bs)
                            .skip(breathPoints.get(i))
                            .limit(breathPoints.get(i + 1) - breathPoints.get(i))
                            .sum()
            );
        }

        long low = 0, high = (long) 1e13;
        while (low < high) {
            long mid = (low + high) / 2;
            if (is_valid(mid)) high = mid;
            else low = mid + 1;
        }
        System.out.println(high);
    }

    boolean is_valid(long ans) {
        int i = 0;
        for (int j = 0; j <= k; j++) {
            long tmp = 0;
            while (true) {
                tmp += breathTimes.get(i);
                if (tmp > ans) break;
                i++;
                if (i == breathTimes.size()) return true;
            }
        }
        return i == breathTimes.size();
    }

}
