from collections import deque

word = input().strip()
edges = [{1}, *({i - 1, i + 1} for i in range(1, len(word) - 1)), {len(word) - 2}]

previous = dict()
for i, c in enumerate(word):
    if c in previous:
        edges[i].add(previous[c])
        edges[previous[c]].add(i)
    previous[c] = i

visited = set()
queue = deque([(0, 0)])
while queue:
    curr, hops = queue.popleft()
    if curr == len(word) - 1:
        print(hops)
        exit()
    for neigh in edges[curr]:
        if neigh in visited:
            continue
        visited.add(neigh)
        queue.append((neigh, hops + 1))
