#include <iostream>
#include <fstream>
#include <vector>
#include <map>
using namespace std;

// functions
vector<int> parseChildren();
int parseNode();
void dfs();

// Global variables
int p = 0;
int nodeId = 0;
string s;
map<int, char> label;
vector<int> edges[100001];
ofstream out("../../data/secret/1000_nodes_1_letters.ans");
ifstream in("../../data/secret/1000_nodes_1_letters.in");
void dfs(int node) {
    for (int i=0; i<edges[node].size(); i++) {
        dfs(edges[node][i]);
    }
    cout << label[node];
}
int parseNode() {
    char c = s[p++];
    int cpId = nodeId;
    label[nodeId++] = c;
    edges[cpId] = parseChildren();
    return cpId;
}
vector<int> parseChildren() {
    vector<int> children;
    if(s[p] == '(') {
        while(s[p++] != ')') {
            children.push_back(parseNode());
        }
    }
    return children;
}

int main() {
    cin >> s;
    parseNode();
    dfs(0);
    cout << endl;
    return 0;
}
