import java.io.*;
import java.util.*;

public class MaartenTreeCutting {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenTreeCutting().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        char[] raw = reader.readLine().toCharArray();
        int n = raw.length;

        if (n == 1) {
            System.out.println(raw[0]);
            return;
        }

        Stack<Character> stack = new Stack<>();
        StringBuilder res = new StringBuilder();

        for (int i = 0; i < n; i++) {
            char c = raw[i];
            if (c == ')')
                res.append(stack.pop());
            else if (raw[i + 1] == '(')
                stack.push(c);
            else if (c != ',' && c != '(')
                res.append(c);
        }

        System.out.println(res);
    }
}
