from collections import deque

m, n = [int(x) for x in input().split()]

grid = []

for i in range(m):
    grid.append(input())

answer = [['X' for _ in range(n)] for _ in range(m)]

dir = [(1, 0), (-1, 0), (0, 1), (0, -1)]


def check(i, j):
    queue = deque()
    visited = set()
    queue.append((i,j))
    visited.add((i, j))
    answer[i][j] = 'O'
    while len(queue) != 0:
        curr = queue.popleft()
        for d in dir:
            (x, y) = (d[0] + curr[0], d[1] + curr[1])
            if (x, y) not in visited and 0 <= x < m and 0 <= y < n and grid[x][y] != '#':
                (pushx, pushy) = (x + d[0], y + d[1])
                if 0 <= pushx < m and 0 <= pushy < n and grid[pushx][pushy] != '#':
                    queue.append((x, y))
                    visited.add((x, y))
                    answer[x][y] = 'O'

for i, line in enumerate(grid):
    for j, c in enumerate(line):
        if line[j] == 'D':
            check(i, j)

for i in range(m):
    print(''.join(answer[i]))
