import java.io.*;
import java.util.*;

import static java.lang.Integer.*;

public class MaartenFloodFill {

    private char[][] grid;
    private Queue<Pos> todo;

    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenFloodFill().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        String[] firstLine = reader.readLine().split(" ");
        int h = parseInt(firstLine[0]);
        int w = parseInt(firstLine[1]);

        grid = new char[h][];
        for (int y = 0; y < h; y++) {
            grid[y] = reader.readLine().toCharArray();
        }

        todo = new LinkedList<>();
        char[][] valid = new char[h][w];

        for (int y = 0; y < h; y++) {
            for (int x = 0; x < w; x++) {
                if (grid[y][x] == 'D') {
                    new Pos(x, y).exploreNeighbours();
                    valid[y][x] = 'O';
                } else
                    valid[y][x] = 'X';
            }
        }

        while (!todo.isEmpty()) {
            Iterator<Pos> iterator = todo.iterator();
            Pos currPos = iterator.next();
            iterator.remove();
            if (valid[currPos.y][currPos.x] == 'O')
                continue;

            for (Pos fromPos : currPos.getNeighbours()) {
                Pos toPos = fromPos.pushTo(currPos);
                if (valid[toPos.y][toPos.x] == 'O' && fromPos.tile() != '#') {
                    valid[currPos.y][currPos.x] = 'O';
                    currPos.exploreNeighbours();
                }
            }
        }

        for (char[] row : valid) {
            System.out.println(String.valueOf(row));
        }
    }

    class Pos {
        int x, y;

        Pos(int x, int y) {
            this.x = x;
            this.y = y;
        }

        char tile() {
            return grid[y][x];
        }

        Pos[] getNeighbours() {
            Pos[] neighbours = new Pos[4];
            neighbours[0] = new Pos(x, y + 1);
            neighbours[1] = new Pos(x, y - 1);
            neighbours[2] = new Pos(x + 1, y);
            neighbours[3] = new Pos(x - 1, y);
            return neighbours;
        }

        void exploreNeighbours() {
            for (Pos neighbour : getNeighbours()) {
                if (neighbour.tile() == '.')
                    todo.add(neighbour);
            }
        }

        Pos pushTo(Pos to) {
            return new Pos(to.x + to.x - this.x, to.y + to.y - this.y);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Pos pos = (Pos) o;
            return x == pos.x && y == pos.y;
        }

        @Override
        public int hashCode() {
            return Objects.hash(x, y);
        }
    }
}
