n = int(input())
code1 = [input().split() for _ in range(n)]
code2 = [input().split() for _ in range(n)]

if any(len(line1) != len(line2) for line1, line2 in zip(code1, code2)):
    # If some lines have different lengths, it's not fraud
    print(-1)
    exit()

mapper = dict()
for line1, line2 in zip(code1, code2):
    for word1, word2 in zip(line1, line2):
        if word1 in mapper and mapper[word1] != word2:
            # If we already have a mapping for word1 but word2 is different, it's not fraud
            print(-1)
            exit()
        mapper[word1] = word2

if len(mapper) != len(set(mapper.values())):
    # If some words map to the same word, it's not fraud
    print(-1)
    exit()

mapper = {word1: word2 for word1, word2 in mapper.items() if word1 != word2}  # Only print non-equal mapped words
print(len(mapper), *sorted(f"{word1} {word2}" for word1, word2 in mapper.items()), sep="\n")
