import java.io.*;
import java.util.*;

import static java.lang.Integer.*;
import static java.lang.Math.*;

public class MaartenCoatisOwls {
    public static void main(String[] args) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in))) {
            new MaartenCoatisOwls().run(reader);
        }
    }

    public void run(BufferedReader reader) throws IOException {
        String[] firstLine = reader.readLine().split(" ");
        int numCoatis = parseInt(firstLine[0]);
        int numOwls = parseInt(firstLine[1]);
        int n = numCoatis + numOwls;

        int[] squads = new int[n];
        int i = 0;
        for (String x : reader.readLine().split(" "))
            squads[i++] = parseInt(x);

        int owl_pos = numCoatis;
        int coati_pos = owl_pos - 1;
        while (coati_pos >= 0 && owl_pos < n) {
            int coati = squads[coati_pos];
            int owl = squads[owl_pos];
            if (coati > owl) {
                squads[coati_pos] -= num_lost(coati, owl);
                owl_pos++;
            } else if (coati < owl) {
                squads[owl_pos] -= num_lost(owl, coati);
                coati_pos--;
            } else {
                coati_pos--;
                owl_pos++;
            }
        }

        if (coati_pos >= 0) {
            System.out.println("coatis");
            System.out.println(sum(squads, 0, coati_pos));
        } else if (owl_pos < n) {
            System.out.println("owls");
            System.out.println(sum(squads, owl_pos, n - 1));
        } else {
            System.out.println("stalemate");
        }
    }

    private double num_lost(double winner, double loser) {
        return ceil(loser * loser / winner);
    }

    private int sum(int[] squads, int start, int end) {
        int sum = 0;
        for (int i = start; i <= end; i++)
            sum += squads[i];
        return sum;
    }
}
