import java.io.*;
import java.util.*;

public class MaartenGradingBinSearchOverflow {
    public static void main(String[] args) {
        try (Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)))) {
            new MaartenGradingBinSearchOverflow().run(sc);
        }
    }

    public void run(Scanner sc) {
        int n = sc.nextInt();
        int t = sc.nextInt();

        if (t == 0 || n == 0) {
            System.out.println("0 0");
            return;
        }
        if (n == 1) {
            System.out.println(t + " 0");
            return;
        }

        int totalTime = (int) (Math.log(n - 1) / Math.log(2)) + 2;

        int low = 0;
        int high = n - 1;
        while (low < high) {
            int mid = (low + high) / 2;
            if (numExamsThatCanBeGraded(totalTime, mid) >= n)
                high = mid;
            else
                low = mid + 1;
        }

        System.out.println((totalTime * t) + " " + (high + 1));
    }

    /*
    T = Train TA
    G = Grade
    Example: with 6 TAs and 5 totalTime, we can grade 15 exams:
        1         T
        2     T       T
        3   T   T   T   G
        4  G G G G G G  G
        5  G G G G G G  G
    completeLevels = 2 (= ⌊log₂(6 + 1)⌋)
    overflowLevel  = 6 (= 2 * (6 - (2 ^ 2 - 1)))
    previousLevel  = 1 (= 2 ^ 2 - 6 / 2)
    return 1 * (5 - 2) + 6 * (5 - 2 - 1)
    */
    private int numExamsThatCanBeGraded(int totalTime, int numTAs) {
        // complete_levels = int(log2(num_TAs + 1))
        // overflow_level = 2 * (num_TAs - (2 ** complete_levels - 1))
        // previous_level = 2 ** complete_levels - overflow_level // 2
        // return previous_level * (total_time - complete_levels) + overflow_level * (total_time - complete_levels - 1)
        int completeLevels = (int) (Math.log(numTAs + 1) / Math.log(2));
        int overflowLevel = 2 * (numTAs - (int) Math.pow(2, completeLevels) + 1);
        int previousLevel = (int) Math.pow(2, completeLevels) - overflowLevel / 2;
        return previousLevel * (totalTime - completeLevels) + overflowLevel * (totalTime - completeLevels - 1);
    }
}
