from math import ceil, floor, log2

n, t = [int(x) for x in input().split()]

# Some observations
# No need to train more than n TA's ==> number of trained TA's at the end should be <= n
# If you train a TA is best to train it as soon as possible

minimum = 1e15
number_of_tas = 1
for i in range(1, n+1):
    training_sessions = floor(log2(i))
    trained_tas = 2 ** training_sessions
    left_to_train = i - trained_tas
    free_to_grade = trained_tas - left_to_train
    time_spent = (training_sessions + 1) * t + (ceil((n - free_to_grade) / i)) * t
    if time_spent < minimum:
        minimum = time_spent
        number_of_tas = i
print(time_spent, number_of_tas)

# This prints the minimum time with just a formula, but doesn't take into account the minimum number of TA's
# training_sessions = floor(log2(n))
# total_time = t * (training_sessions + 1)
# if n - 2 ** training_sessions > 0:
#     total_time += t 
# print(total_time)