import java.io.*;
import java.util.*;

public class MaartenStack {
    public static void main(String[] args) {
        try (Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)))) {
            new MaartenStack().run(sc);
        }
    }

    public void run(Scanner sc) {
        int n = sc.nextInt();
        Stack<Long> heights = new Stack<>();
        Stack<Long> widths = new Stack<>();
        heights.push(-1L);
        widths.push(0L);
        long maxArea = 0;
        for (int i = 0; i <= n; i++) {
            final long h, w;
            if (i < n) {
                h = sc.nextInt();
                w = sc.nextInt();
            } else h = w = 0;
            long addW = 0;
            while (h <= heights.peek()) {
                long oldH = heights.pop();
                long oldW = widths.pop();
                addW += oldW;
                maxArea = Long.max(maxArea, oldH * addW);
            }
            heights.push(h);
            widths.push(w + addW);
        }
        System.out.println(maxArea);
    }
}
