MOD = 313109


def mod_pow(base, exp):
    res = 1
    while exp > 0:
        if exp % 2 == 1:
            res = (res * base) % MOD
        base = (base * base) % MOD
        exp //= 2
    return res % MOD


invmemo = dict()


def modinv(a):
    if a not in invmemo:
        invmemo[a] = mod_pow(a, MOD - 2)  # Because a^(p-2) ≡ a^-1 (mod p, where p is prime)
    return invmemo[a]


facmemo = [1, 1, 2, 6]
prev = 6
for i in range(4, MOD):
    prev *= i
    prev %= MOD
    facmemo.append(prev)


def factorial(n):
    if n < MOD:
        return facmemo[n]
    return 0


q = int(input())
for _ in range(q):
    n = int(input()) // 2
    # For n > MOD, factorial(n) will be 0, so the final answer becomes 0 as well, which is wrong.
    print((factorial(2 * n) * modinv((factorial(n) * factorial(n + 1)) % MOD)) % MOD)
