MOD = 313109


def exgcd(a, b):
    if a == 0:
        return b, 0, 1
    else:
        g, y, x = exgcd(b % a, a)
        return g, x - (b // a) * y, y


invmemo = dict()


def modinv(a):
    if a not in invmemo:
        g, x, y = exgcd(a, MOD)
        if g != 1:
            # This case happens quite often when n > MOD, because n! becomes 0 (modulo MOD).
            raise Exception("modular inverse does not exist")
        else:
            invmemo[a] = x % MOD
    return invmemo[a]


facmemo = [1, 1, 2, 6]
prev = 6
for i in range(4, MOD):
    prev *= i
    prev %= MOD
    facmemo.append(prev)


def factorial(n):
    if n < MOD:
        return facmemo[n]
    return 0


q = int(input())
for _ in range(q):
    n = int(input()) // 2
    # For n > MOD, factorial(n) will be 0, which will break in modinv, which cannot use 0 in exgcd.
    print((factorial(2 * n) * modinv((factorial(n) * factorial(n + 1)) % MOD)) % MOD)
