#include <iostream>

using namespace std;

#define ll long long

const ll PMAX = 313109;
ll fact[PMAX+5];

ll lg_put(ll base,ll exp)
{
    ll res =1;
    while(exp>0)
    {
        if(exp&1)
            res = (res * base )%PMAX;
        base = (base * base)%PMAX;
        exp= exp>>1;
    }
    return res%PMAX;
}

void precalc()
{
    fact[0] = 1;
    fact[1] = 1;
    for(int i=2;i<=PMAX;i++)
        fact[i] = (fact[i-1] * i)%PMAX;
}

// https://stackoverflow.com/a/33634773
typedef unsigned long long num;

/* x such that a*x = 1 mod p */
num modinv(num a, num p)
{
    return lg_put(a, p - 2);
}

/* n chose m mod p */
/* computed with the theorem of Lucas */
num modbinom(num n, num m, num p)
{
    num i, result, divisor, n_, m_;

    if (m == 0)
        return 1;

    /* check for the likely case that the result is zero */
    if (n < m)
        return 0;

    for (n_ = n, m_ = m; m_ > 0; n_ /= p, m_ /= p)
        if (n_ % p < m_ % p)
            return 0;

    for (result = 1; n >= p || m >= p; n /= p, m /= p) {
        result *= modbinom(n % p, m % p, p);
        result %= p;
    }

    /* avoid unnecessary computations */
    if (m > n - m)
        m = n - m;

    divisor = 1;
//    for (i = 0; i < m; i++) {
//        result *= n - i; // n * (n-1) * ... * (n-m+1) = n! / (n-m)!
//        result %= p;
//
//        divisor *= i + 1; // 1 * 2 * ... * m
//        divisor %= p;
//    }

    result *= fact[n];
    result %= p;

    divisor *= fact[n - m];
    divisor %= p;

    divisor *= fact[m];
    divisor %= p;

    result *= modinv(divisor, p);
    result %= p;

    return result;
}

ll catalan(ll n)
{
    ll a = 2 * n;
    num b = modbinom(a, n, PMAX);
    a = lg_put((n+1) % PMAX, PMAX-2);
    return ((b * a) %PMAX);
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int q;
    ll n;
    cin>>q;
    precalc();
    while(q--)
    {
        cin>>n;
        n = n >>1;
        cout<<catalan(n)<<"\n";
    }


    return 0;

}
