import java.io.*;
import java.util.*;

public class StackOverflow_memo {

    static final long PMAX = 313109;
    static long[] fact = new long[(int) PMAX + 5];

    static long lg_put(long base, long exp) {
        long res = 1;
        while (exp > 0) {
            if ((exp & 1) == 1)
                res = (res * base) % PMAX;
            base = (base * base) % PMAX;
            exp = exp >> 1;
        }
        return res % PMAX;
    }

    static void precalc() {
        fact[0] = 1;
        fact[1] = 1;
        for (int i = 2; i <= PMAX; i++)
            fact[i] = (fact[i - 1] * i) % PMAX;
    }

    // https://stackoverflow.com/a/33634773

    /* x such that a*x = 1 mod p */
    static long modinv(long a, long p) {
        return lg_put(a, p - 2);
    }

    /* n chose m mod p */
    /* computed with the theorem of Lucas */
    static long modbinom(long n, long m, long p) {
        long i, result, divisor, n_, m_;

        if (m == 0)
            return 1;

        /* check for the likely case that the result is zero */
        if (n < m)
            return 0;

        for (n_ = n, m_ = m; m_ > 0; n_ /= p, m_ /= p)
            if (n_ % p < m_ % p)
                return 0;

        for (result = 1; n >= p || m >= p; n /= p, m /= p) {
            result *= modbinom(n % p, m % p, p);
            result %= p;
        }

        /* avoid unnecessary computations */
        if (m > n - m)
            m = n - m;

        divisor = 1;
//    for (i = 0; i < m; i++) {
//        result *= n - i; // n * (n-1) * ... * (n-m+1) = n! / (n-m)!
//        result %= p;
//
//        divisor *= i + 1; // 1 * 2 * ... * m
//        divisor %= p;
//    }

        result *= fact[(int) n];
        result %= p;

        divisor *= fact[(int) (n - m)];
        divisor %= p;

        divisor *= fact[(int) m];
        divisor %= p;

        result *= modinv(divisor, p);
        result %= p;

        return result;
    }

    static long catalan(long n) {
        long a = 2 * n;
        long b = modbinom(a, n, PMAX);
        a = lg_put((n + 1) % PMAX, PMAX - 2);
        return ((b * a) % PMAX);
    }

    public static void main(String[] args) {
        try (Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)))) {
            int q = sc.nextInt();
            precalc();
            long n;
            for (int i = 0; i < q; i++) {
                n = sc.nextLong();
                System.out.println(catalan(n >> 1));
            }
        }
    }
}
