import java.io.*;
import java.util.*;

public class Generate {

    static Random random = new Random(3141592654L);

    static int[][] problems = {
            // n, repetition
            {10, 1},
            {10, 2},
            {10, 3},
            {100, 1},
            {100, 2},
            {100, 3},
            {400, 1},
            {400, 2},
            {400, 3},
    };

    public static void main(String[] args) throws IOException {
        for (int[] problem : problems) {
            write(generate(problem), problemName(problem));
        }
        write(generateDraws(400), "n_400_draws");
    }

    private static void write(String input, String problemName) throws IOException {
        String answer = new D_Correct().simulate(new Scanner(input));
        FileWriter file = new FileWriter("../data/secret/" + problemName + ".in");
        file.write(input);
        file.close();
        file = new FileWriter("../data/secret/" + problemName + ".ans");
        file.write(answer + "\n");
        file.close();
    }

    private static String generateDraws(int n) {
        List<String> matches = generateMatches(n);

        StringBuilder sb = new StringBuilder();
        sb.append(n).append('\n');
        for (String match : matches) {
            int score = random.nextInt(100);
            sb.append(match).append(' ').append(score).append(' ').append(score).append('\n');
        }
        return sb.toString();
    }

    private static String generate(int[] problem) {
        int n = problem[0];
        List<String> matches = generateMatches(n);

        StringBuilder sb = new StringBuilder();
        sb.append(n).append('\n');
        for (String match : matches) {
            sb.append(match).append(' ')
                    .append(random.nextInt(100)).append(' ')
                    .append(random.nextInt(100)).append('\n');
        }
        return sb.toString();
    }

    private static List<String> generateMatches(int n) {
        Set<String> teamsSet = new HashSet<>(n);
        while (teamsSet.size() < n) {
            teamsSet.add(random.ints('A', 'z' + 1)
                    .filter(c -> c <= 'Z' || c >= 'a')
                    .limit(random.nextInt(20) + 1)
                    .collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append)
                    .toString());
        }
        String[] teams = teamsSet.toArray(new String[0]);
        int m = n * (n - 1) / 2;
        List<String> matches = new ArrayList<>(m);
        for (int i = 0; i < n; i++) {
            for (int j = i + 1; j < n; j++) {
                matches.add(random.nextDouble() < 0.5 ? teams[i] + " " + teams[j] : teams[j] + " " + teams[i]);
            }
        }
        Collections.shuffle(matches, random);
        return matches;
    }

    private static String problemName(int[] problem) {
        return "n_" + problem[0] + "_" + problem[1];
    }
}
