import java.io.*;
import java.util.*;
import java.util.stream.*;

public class D_NoLimit {
    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new D_NoLimit().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        System.out.println(simulate(sc));
    }

    public String simulate(Scanner sc) {
        int n = sc.nextInt();
        int matches = n * (n - 1) / 2;
        Map<String, Integer> scores = new HashMap<>();
        for (int i = 0; i < matches; i++) {
            String teamA = sc.next(), teamB = sc.next();
            int scoreA = sc.nextInt(), scoreB = sc.nextInt();
            int diff = scoreA - scoreB;
            scores.putIfAbsent(teamA, 0);
            scores.putIfAbsent(teamB, 0);
            if (diff > 0)
                scores.put(teamA, scores.get(teamA) + 3);
            else if (diff < 0)
                scores.put(teamB, scores.get(teamB) + 3);
            else {
                scores.put(teamA, scores.get(teamA) + 1);
                scores.put(teamB, scores.get(teamB) + 1);
            }
        }
        return scores.entrySet()
                .stream()
                .sorted((e1, e2) -> e1.getValue().equals(e2.getValue())
                        ? e1.getKey().compareTo(e2.getKey())
                        : e2.getValue().compareTo(e1.getValue()))
                .map(e -> e.getKey() + " " + e.getValue())
                .collect(Collectors.joining("\n"));
    }
}
